<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

$host = "localhost";
$user = "root";
$pass = "";
$db   = "school";

$conn = mysqli_connect($host, $user, $pass, $db);

if (!$conn) {
    echo json_encode(["status" => "error", "message" => "DB connection failed"]);
    exit;
}

$student_id = $_GET['student_id'];

// Fetch paid months
$query = mysqli_query($conn, "
    SELECT month_year, amount 
    FROM fees 
    WHERE student_id='$student_id'
");

$paidMonths = [];
$totalPaid = 0;

while ($row = mysqli_fetch_assoc($query)) {
    $paidMonths[] = $row['month_year'];  // format: 2025-11
    $totalPaid += (int)$row['amount'];
}

/*
-------------------------------------------
Create full month list for current year
-------------------------------------------
*/
$currentYear = date("Y");

$allMonths = [];
for ($m = 1; $m <= 12; $m++) {
    $allMonths[] = $currentYear . "-" . str_pad($m, 2, "0", STR_PAD_LEFT);
}

/*
-------------------------------------------
Find unpaid months
-------------------------------------------
*/
$unpaidMonths = array_values(array_diff($allMonths, $paidMonths));

/*
-------------------------------------------
Calculate total due
-------------------------------------------
Assume monthly fee = 100 (change as needed)
-------------------------------------------
*/
$monthlyFee = 100;
$totalUnpaid = count($unpaidMonths) * $monthlyFee;

echo json_encode([
    "status" => "success",
    "paid_months" => $paidMonths,
    "unpaid_months" => $unpaidMonths,
    "total_paid" => $totalPaid,
    "total_unpaid" => $totalUnpaid
]);

?>
