<?php
header("Content-Type: application/json");
$host = "localhost";    
$user = "codelet_paulmanoj";
$pass = "Manoj#123456";
$db   = "codelet_ecommerce_db";

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    die("Connection Failed: " . $conn->connect_error);
}
//include "config.php"; // Your DB connection file

$response = array();

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $mobile = $_POST['mobile'] ?? "";
    $email  = $_POST['email'] ?? "";

    if (empty($mobile) || empty($email)) {
        $response['status'] = "error";
        $response['message'] = "All fields are required";
        echo json_encode($response);
        exit;
    }

    if (strlen($mobile) != 10 || !is_numeric($mobile)) {
        $response['status'] = "error";
        $response['message'] = "Invalid mobile number";
        echo json_encode($response);
        exit;
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response['status'] = "error";
        $response['message'] = "Invalid email";
        echo json_encode($response);
        exit;
    }

    // Check if mobile already exists
    $check = $conn->prepare("SELECT id FROM register WHERE mobile = ?");
    $check->bind_param("s", $mobile);
    $check->execute();
    $check->store_result();

    if ($check->num_rows > 0) {
        $response['status'] = "exists";
        $response['message'] = "Mobile number already registered";
        echo json_encode($response);
        exit;
    }

    // Insert user
    $stmt = $conn->prepare("INSERT INTO register (mobile, email) VALUES (?, ?)");
    $stmt->bind_param("ss", $mobile, $email);

    if ($stmt->execute()) {
        $response['status'] = "success";
        $response['message'] = "Registration successful";
    } else {
        $response['status'] = "error";
        $response['message'] = "Database error";
    }

    echo json_encode($response);
}
?>
